use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- DEV-89741
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[VX_sp_LinkSampleToSurvey]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[VX_sp_LinkSampleToSurvey]
'

declare @PanelClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_LinkSampleToSurvey]
 @clientId    INT,
 @panelId    INT,
 @sampleId    INT,
 @userId     INT,
 @destinationSurveyId INT,
 @doPanelistDataTransfer BIT,
 @doSurveyDataCopy  BIT,
 @sourceSurveyId   INT,
 @autoGeneratePIN  INT,
 @pinSource    nvarchar(max) = '''',
 @currentIndex   INT,
 @batchSize    INT,
 @updateOnly bit = 0
AS
BEGIN
 DECLARE @schemaName NVARCHAR(50)
 DECLARE @destinationSchemaName NVARCHAR(100)
 DECLARE @panelSchema NVARCHAR(50)
 DECLARE @sql NVARCHAR(max)
 SET @schemaName = ''[A4Survey_Client_''+CONVERT(nvarchar, @clientId)+'']''
 SET @destinationSchemaName = @schemaName+''.[Survey_''+CONVERT(nvarchar, @clientId)+''_''+CONVERT(nvarchar, @destinationSurveyId)+'']''
 SET @panelSchema = ''[A4Panel_Client_''+CONVERT(nvarchar, @clientId)+'']''

 CREATE TABLE #PanelistToInsert ( [Id] INT )
 CREATE CLUSTERED INDEX Temp_IDX_PanelistId ON #PanelistToInsert([Id])

 SET @sql = ''
 INSERT INTO #PanelistToInsert ([Id])
 SELECT [Panelists_Id]
 FROM (
  SELECT ROW_NUMBER() OVER (
   ORDER BY SP.[Panelists_Id] ) AS [ROW_NUMBER], SP.[Panelists_Id]
  FROM ''+@panelSchema+''.[dbo].[SamplePanelist] AS SP
  WHERE SP.[Samples_Id] = @sampleId
  ) AS rowOverSP
 WHERE rowOverSP.[ROW_NUMBER] BETWEEN @currentIndex + 1 AND @currentIndex + @batchSize ''

 IF @updateOnly=0
 BEGIN
   SET @sql = @sql + ''AND NOT EXISTS (SELECT 1 FROM ''+@destinationSchemaName+''.[Respondent] r WHERE r.[panelistId] = rowOverSP.[Panelists_Id])''
 END

 SET @sql = @sql + '' ORDER BY rowOverSP.[ROW_NUMBER] ''

 EXEC sp_executesql @sql, N''@sampleId INT, @currentIndex INT, @batchSize INT'', @sampleId, @currentIndex, @batchSize

 -- Process the current sample to create/update the respondents and responses
 EXEC A4S_sp_ProcessSamplePanelists @clientId, @panelId, @sampleId, @userId, @destinationSurveyId, @doPanelistDataTransfer, @autoGeneratePIN, @pinSource,@updateOnly

 IF @doSurveyDataCopy = 1
 BEGIN
  DECLARE @sourceSchemaName NVARCHAR(100)
   SET @sourceSchemaName = @schemaName+''.[Survey_''+CONVERT(nvarchar, @clientId)+''_'' +CONVERT(nvarchar, @sourceSurveyId)+'']''

  -- Update existing respondent data matching panelistIds
  SET @sql =
  ''UPDATE ''+@destinationSchemaName+''.[Response]
  SET [RpsContent] = sourceResponse.[RpsContent], [modifiedBy] = @userId, [modified] = GETUTCDATE(), [source] = 4
  FROM ''+@sourceSchemaName+''.[Response] sourceResponse WITH(NOLOCK)
  INNER JOIN ''+@sourceSchemaName+''.[Respondent] sourceRespondent WITH(NOLOCK) on sourceRespondent.[ResRespondent] = sourceResponse.[RpsRespondent]
  INNER JOIN #PanelistToInsert panelist WITH(NOLOCK) ON panelist.[Id] = sourceRespondent.[panelistId]
  INNER JOIN ''+@destinationSchemaName+''.[Respondent] destinationRespondent WITH(NOLOCK) ON destinationRespondent.[panelistId] = sourceRespondent.[panelistId]
  INNER JOIN ''+@destinationSchemaName+''.[Response] destinationResponse WITH(NOLOCK)
   ON destinationResponse.[RpsRespondent] = destinationRespondent.[ResRespondent]
     AND destinationResponse.[RpsQuestion] = sourceResponse.[RpsQuestion] AND sourceResponse.[RpsMatrix] = 1 AND sourceResponse.[RpsMention] = 1
  WHERE destinationResponse.[RpsRespondent] IS NOT NULL''
  EXEC sp_executesql @sql,  N''@userId INT'', @userId

  -- Insert missing respondent data matching panelistIds
  SET @sql =
  ''INSERT INTO ''+@destinationSchemaName+''.[Response]
  ([RpsRespondent], [RpsVariableId], [RpsQuestion], [RpsMatrix], [RpsMention], [RpsContent], [projectId], [modifiedBy], [modified], [source])
  SELECT
  destinationRespondent.[ResRespondent], variable.[Id], sourceResponse.[RpsQuestion], sourceResponse.[RpsMatrix],
  sourceResponse.[RpsMention], sourceResponse.[RpsContent],  @surveyId, @userId, GETUTCDATE(), 4
  FROM ''+@sourceSchemaName+''.[Response] sourceResponse WITH(NOLOCK)
  INNER JOIN ''+@sourceSchemaName+''.[Respondent] sourceRespondent WITH(NOLOCK) on sourceRespondent.[ResRespondent] = sourceResponse.[RpsRespondent]
  INNER JOIN #PanelistToInsert panelist WITH(NOLOCK) ON panelist.[Id] = sourceRespondent.[panelistId]
  INNER JOIN ''+@destinationSchemaName+''.[Respondent] destinationRespondent WITH(NOLOCK) ON destinationRespondent.[panelistId] = sourceRespondent.[panelistId]
  LEFT JOIN ''+@destinationSchemaName+''.[Response] destinationResponse  WITH(NOLOCK)
   ON destinationResponse.[RpsRespondent] = destinationRespondent.[ResRespondent] AND destinationResponse.[RpsQuestion] = sourceResponse.[RpsQuestion]
      AND sourceResponse.[RpsMatrix] = destinationResponse.[RpsMatrix] AND sourceResponse.[RpsMention] = destinationResponse.[RpsMention]
  INNER JOIN ''+@schemaName+''.[SAT].[Variables] variable WITH(NOLOCK) ON sourceResponse.[RpsQuestion] = variable.[Name] AND variable.[Version] = 0
  INNER JOIN ''+@schemaName+''.[SAT].[BlockItems] blockItem WITH(NOLOCK) ON variable.[QuestionId] = blockItem.[Id] AND blockItem.[Version] = 0
  INNER JOIN ''+@schemaName+''.[SAT].[Blocks] block WITH(NOLOCK) ON blockItem.[BlockId] = block.[Id] AND block.[Version] = 0
  WHERE destinationResponse.[RpsRespondent] IS NULL AND block.QuestionnaireId = @surveyId''
  EXEC sp_executesql @sql,  N''@surveyId INT, @userId INT'', @destinationSurveyId, @userId
 END

 IF @updateOnly = 0
 BEGIN
    SET @sql = ''
    UPDATE r
    SET
    r.[ResActive] = CASE p.[Status] WHEN 6 THEN 0 ELSE r.[ResActive] END,
    r.[ResEmail] = p.[Email],
    r.[ResPhone] = p.[Phone]
    FROM ''+@destinationSchemaName+''.[Respondent] r
    INNER JOIN ''+@panelSchema+''.[dbo].[SamplePanelist] sp ON sp.[Samples_Id] = @sampleId AND r.[panelistId] = sp.[Panelists_Id]
    INNER JOIN ''+@panelSchema+''.[dbo].[Panelists] p ON sp.[Panelists_Id] = p.[Id]
    WHERE (p.[Status] = 6 AND r.[ResActive] <> 0)
        OR r.[ResEmail] <> p.[Email]
        OR r.[ResPhone] <> p.[Phone];''
    EXEC sp_executesql @sql, N''@sampleId INT'', @sampleId;

    SET @sql = ''UPDATE '' + @schemaName + ''.[dbo].[ProjectStatistics] SET [NeedsUpdate] = 1 WHERE [ProjectId] = @surveyId AND [NeedsUpdate] = 0;''
    EXEC sp_executesql @sql, N''@surveyId INT'', @destinationSurveyId;
 END

 --we need to update the modified field of the respondents and responses for the CC integration service
   SET @sql = ''
   UPDATE
   ''+@destinationSchemaName+''.Respondent
   SET
   modified=@modified
   FROM
   ''+@destinationSchemaName+''.Respondent r
   INNER JOIN
    #PanelistToInsert panelist ON panelist.[Id] = r.[panelistId]

   UPDATE
   ''+@destinationSchemaName+''.response
   SET
   modified=@modified
   FROM
   ''+@destinationSchemaName+''.response rps
   INNER JOIN
   ''+@destinationSchemaName+''.respondent res on res.resrespondent = rps.rpsrespondent
   INNER JOIN
    #PanelistToInsert panelist ON panelist.[Id] = res.[panelistId]''

  DECLARE @timestamp DATETIME = GETUTCDATE()
  EXEC sp_executesql @sql , N''@modified DATETIME'',@timestamp
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		print 'Panel Client Payload 1'
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 2'
		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Panel Client Payload done for panel client ' + @ThisPanelClient + '!'

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
